﻿using System;

namespace TrackAnalysis
{
    public class MotionNoteMaker : NoteMakerBase
    {
        override protected
            bool
            NotValidType(
                string type)
        {
            Type motionType;
            return type.Substring(1) != "MO" ||
                !MotionNote.keymap.TryGetValue(type, out motionType);
        }

        override protected
            Note
            MakeShort(
                string code,
                string type,
                float timing)
        {
            return (MotionNote)Activator.CreateInstance
                (MotionNote.keymap[type], code, timing);
        }

        override protected
            Note
            MakeLong(
                string code,
                string type,
                float timing)
        {
            float start = Timing.Value;
            Timing = null;

            return (MotionNote)Activator.CreateInstance
                (MotionNote.keymap[type], code, start, timing);
        }
    }
}
