﻿namespace TrackAnalysis
{
    public class ButtonNoteMaker : NoteMakerBase
    {
        override protected
            bool
            NotValidType(
                string type)
        {
            return type.Substring(1) != "BT";
        }

        override protected
            Note
            MakeShort(
                string code,
                string type,
                float timing)
        {
            return new Note(code, type, timing);
        }

        override protected
            Note
            MakeLong(
                string code,
                string type,
                float timing)
        {
            float start = Timing.Value;
            Timing = null;

            return new Note(code, type, start, timing);
        }
    }
}