﻿using UnityEngine;
using UnityEngine.TestTools;
using NUnit.Framework;
using System.Collections;
using Windows.Kinect;
using System.Runtime.InteropServices;
using System;

class CoordinateMapperViewTests
{
    // A UnityTest behaves like a coroutine in PlayMode
    // and allows you to yield null to skip a frame in EditMode
    [UnityTest]
    public IEnumerator MainTexture_Equal_Texture_Generate_By_Shader_When_After_Update()
    {
        yield return null;

        GameManager.Instance.SceneTransition("InGame");

        yield return null;

        var Managers = GameObject.Find("Managers");

        var CoordinateMapperManager = Managers.GetComponent<CoordinateMapperManager>();

        var tmpObj = GameObject.CreatePrimitive(PrimitiveType.Plane);
        tmpObj.GetComponent<Renderer>().material = Resources.Load("GreenScreen/GreenScreen.mat", typeof(Material)) as Material;

        tmpObj.GetComponent<Renderer>().material.SetTexture("_MainTex", CoordinateMapperManager.ColorTexture);

        var DepthPoints = CoordinateMapperManager.DepthCoordinates;
        var DepthBuffer = new ComputeBuffer(DepthPoints.Length, sizeof(float) * 2);
        tmpObj.GetComponent<Renderer>().material.SetBuffer("depthCoordinates", DepthBuffer);

        var BodyIndexPoints = CoordinateMapperManager.BodyIndexBuffer;
        var BodyIndexBuffer = new ComputeBuffer(BodyIndexPoints.Length, sizeof(float));
        tmpObj.GetComponent<Renderer>().material.SetBuffer("bodyIndexBuffer", BodyIndexBuffer);

        var CoordinateMapperView = GameObject.Find("CoordinateMapView");
        // Use the Assert class to test conditions.
        // yield to skip a frame
        yield return null;

        var expected = tmpObj.GetComponent<Renderer>().material.mainTexture;
        var actual = CoordinateMapperView.GetComponent<Renderer>().material.mainTexture;

        Assert.AreEqual(expected, actual, "texture of gameobject should be same as texture which made by shader.");
    }
}
