﻿using System.Runtime.InteropServices;
using Windows.Kinect;

namespace KinectModule
{
    public class RealDepthFrame : IDepthFrame
    {
        private static ushort[] _Buffer = new ushort[KinectConstants.DepthWidth *
                                                     KinectConstants.DepthHeight];

        public RealDepthFrame(DepthFrame frame)
        {
            if (frame != null)
            {
                var DepthData = GCHandle.Alloc(_Buffer, GCHandleType.Pinned);
                frame.CopyFrameDataToIntPtr(DepthData.AddrOfPinnedObject(), (uint)_Buffer.Length * sizeof(ushort));
                DepthData.Free();
            }
        }

        public ushort[] GetData()
        {
            return _Buffer;
        }
    }
}