﻿using System.Collections.Generic;
using System.Linq;
using Windows.Kinect;

namespace KinectModule
{
    public class RealBody : IBody
    {
        private Body _Body;
        private Dictionary<JointType, IJoint> _Joints;

        public bool                          IsTracked
        {
            get
            {
                return _Body.IsTracked;
            }
        }
        public Dictionary<JointType, IJoint> Joints
        {
            get
            {
                return _Joints;
            }
        }
        public Body                          Value
        {
            get
            {
                return _Body;
            }
        }

        public RealBody(Body body)
        {
            if (body != null)
            {
                _Body = body;
                _Joints = _Body.Joints.Select(x => new KeyValuePair<JointType, IJoint>
                                            (x.Key, new RealJoint(x.Value)))
                                      .ToDictionary(x => x.Key, x => x.Value);
            }
        }

        public override bool Equals(object obj)
        {
            return Equals(obj as IBody);
        }

        public bool Equals(IBody obj)
        {
            if (_Body == null)
                return obj == null;

            var keys = Joints.Select(x => x.Key);
            foreach (var key in keys)
            {
                if (!Joints[key].Equals(obj.Joints[key]))
                    return false;
            }

            return IsTracked.Equals(obj.IsTracked);
        }

        public override int GetHashCode()
        {
            return 0;
        }
    }
}