﻿using Windows.Kinect;

namespace KinectModule
{
    public class RealMultiSourceFrame : IMultiSourceFrame
    {
        public IColorFrame     LastColorFrame
        { get; private set; }
        public IBodyIndexFrame LastBodyIndexFrame
        { get; private set; }
        public IDepthFrame     LastDepthFrame
        { get; private set; }
        public IBodyFrame      LastBodyFrame
        { get; private set; }

        public RealMultiSourceFrame(MultiSourceFrame sourceFrame)
        {
            if (sourceFrame == null)
            {
                LastColorFrame     = new RealColorFrame    (null);
                LastBodyIndexFrame = new RealBodyIndexFrame(null);
                LastDepthFrame     = new RealDepthFrame    (null);
                LastBodyFrame      = new RealBodyFrame     (null);

                return;
            }

            using (var colorFrame     = sourceFrame.ColorFrameReference    .AcquireFrame())
                LastColorFrame        = new RealColorFrame    (colorFrame);
            using (var bodyIndexFrame = sourceFrame.BodyIndexFrameReference.AcquireFrame())
                LastBodyIndexFrame    = new RealBodyIndexFrame(bodyIndexFrame);
            using (var depthFrame     = sourceFrame.DepthFrameReference    .AcquireFrame())
                LastDepthFrame        = new RealDepthFrame    (depthFrame);
            using (var bodyFrame      = sourceFrame.BodyFrameReference     .AcquireFrame())
                LastBodyFrame         = new RealBodyFrame     (bodyFrame);
        }
    }
}