﻿using System;
using Windows.Kinect;

namespace KinectModule
{
    public class RealJoint : IJoint
    {
        private Joint _Joint;

        public CameraSpacePoint Position
        {
            get
            {
                return _Joint.Position;
            }
        }

        public RealJoint(Joint joint)
        {
            _Joint = joint;
        }

        public override bool Equals(object obj)
        {
            return Equals(obj as IJoint);
        }

        public bool Equals(IJoint obj)
        {
            return Math.Abs(Position.X - obj.Position.X) < 0.05 &&
                   Math.Abs(Position.Y - obj.Position.Y) < 0.05 &&
                   Math.Abs(Position.Z - obj.Position.Z) < 0.05;
        }

        public override int GetHashCode()
        {
            return (int)Position.X + (int)Position.Y + (int)Position.Z;
        }
    }
}