﻿using System.Runtime.InteropServices;
using Windows.Kinect;

namespace KinectModule
{
    public class RealBodyIndexFrame : IBodyIndexFrame
    {
        private static byte[] _Buffer = new byte[KinectConstants.DepthWidth *
                                                 KinectConstants.DepthHeight];

        public RealBodyIndexFrame(BodyIndexFrame frame)
        {
            if (frame != null)
            {
                var BodyIndexData = GCHandle.Alloc(_Buffer, GCHandleType.Pinned);
                frame.CopyFrameDataToIntPtr(BodyIndexData.AddrOfPinnedObject(), (uint)_Buffer.Length);
                BodyIndexData.Free();
            }
        }

        public byte[] GetData()
        {
            return _Buffer;
        }
    }
}