﻿using System.Linq;
using Windows.Kinect;

namespace KinectModule
{
    public class RealBodyFrame : IBodyFrame
    {
        private static Body[] _Buffer = new Body[KinectConstants.BodyCount];

        public RealBodyFrame(BodyFrame frame)
        {
            if (frame != null)
            {
                frame.GetAndRefreshBodyData(_Buffer);
            }
        }

        public IBody[] GetData()
        {
            return Enumerable.Range(0, KinectConstants.BodyCount)
                             .ToList()
                             .Select(x => new RealBody(_Buffer[x]))
                             .ToArray();
        }
    }
}