﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using Windows.Kinect;

public class MotionView : MonoBehaviour {
	Pair<float, MotionState> recent;
	public GameObject CoordinateMapperManager;
	CoordinateMapperManager _coordinateMapperManager;
	Body[] body;

	// Use this for initialization
	void Start () {
		recent = new Pair<float, MotionState>
		{
			first = 0,
			second = MotionState.UNKNOWN
		};
		
		if(CoordinateMapperManager == null)
			return;
		_coordinateMapperManager
			= CoordinateMapperManager.GetComponent<CoordinateMapperManager>();
		
		body = _coordinateMapperManager.GetBodyBuffer();
	}
	
	// Update is called once per frame
	void Update () {
		recent.first += Time.deltaTime;
		recent.second = DetermineState();

        InputManager.Instance.CurrentMotionState = recent.second;
	}

	MotionState DetermineState()
	{
        if (body == null)
            return MotionState.UNKNOWN;

		int idx;
		for(idx = 0; idx < body.Length; ++idx)
			if (body[idx] != null && body[idx].IsTracked)
                break;
		if(idx == body.Length || body[idx].Joints == null)
			return MotionState.UNKNOWN;

        CameraSpacePoint head      = body[idx].Joints[JointType.Head     ]
									 .Position,
                         leftHand  = body[idx].Joints[JointType.HandLeft ]
						 			 .Position,
                         rightHand = body[idx].Joints[JointType.HandRight]
						 			 .Position;

        MotionState s = MotionState.UNKNOWN;
        if (head.Y < leftHand.Y && head.Y < rightHand.Y)
            s |= MotionState.HURRAY;
        if (Distance(leftHand, rightHand) > 0.3f)
            s |= MotionState.CLAP_PREPARE;
        if (Distance(leftHand, rightHand) < 0.1f)
            s |= MotionState.CLAP_DONE;

        return s;
	}

	float Distance(CameraSpacePoint a, CameraSpacePoint b)
    {
        return Mathf.Sqrt(Mathf.Pow(a.X - b.X, 2.0f) +
                          Mathf.Pow(a.Y - b.Y, 2.0f) +
                          Mathf.Pow(a.Z - b.Z, 2.0f));
    }

	public Pair<float, MotionState> GetState()
	{
		return recent;
	}
}

[System.Flags]
public enum MotionState : uint
{
    UNKNOWN = 0,
    CLAP_PREPARE = 1,
    CLAP_DONE = 2,
    HURRAY = 4
}

public class Pair<T1, T2>
{
    public T1 first;
    public T2 second;
}