using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using UnityEngine;

public abstract class MotionNote : Note
{
    public abstract Sprite Image { get; }

    public MotionNote(float start, float end = 0f)
        : base(start == end ? NoteType.SMO : NoteType.LMO, start, end) { }
    public MotionNote(string key, float start, float end = 0f)
        : this(start, end) { }

    public abstract IEnumerator Checkpoint();
    public abstract bool FinalJudgeAction();

    public bool IsChecked { get; protected set; }

    public MotionSampleDisplay MotionSampleDisplay { get; set; }

    public static readonly Dictionary<string, Type> keymap
        = new Dictionary<string, Type>
        {
            { "CP", typeof(Clap) },

            { "JP", typeof(Jump) },

            { "BP", typeof(PushUp) },
            { "LP", typeof(PushUp) },
            { "RP", typeof(PushUp) },

            { "BK", typeof(PushUp) },
            { "LK", typeof(PushUp) },
            { "RK", typeof(PushUp) },

            { "BI", typeof(Piano) },
            { "LI", typeof(Piano) },
            { "RI", typeof(Piano) },

            { "BG", typeof(Guard) },
            { "LG", typeof(Guard) },
            { "RG", typeof(Guard) },
            
            { "BL", typeof(Guard) },
            { "LL", typeof(Guard) },
            { "RL", typeof(Guard) },

            // Long motion
            { "BU", typeof(Clap) },
            { "LU", typeof(Guard) },
            { "RU", typeof(Guard) },

            { "BD", typeof(Guard) },
            { "LD", typeof(Guard) },
            { "RD", typeof(Guard) },

            { "JS", typeof(Guard) },

            { "BH", typeof(Guard) },
            { "LH", typeof(Guard) },
            { "RH", typeof(Guard) },

            { "OT", typeof(Guard) },
        };

    protected static Sprite LoadNewSprite(string FilePath, float PixelsPerUnit = 100.0f)
    {
        Sprite NewSprite = new Sprite();
        Texture2D SpriteTexture = LoadTexture(FilePath);

        if (SpriteTexture == null)
            return null;

        NewSprite = Sprite.Create(SpriteTexture,
                    new Rect(0, 0, SpriteTexture.width, SpriteTexture.height),
                    new Vector2(0.5f, 0.5f), PixelsPerUnit);

        return NewSprite;
    }

    private static Texture2D LoadTexture(string FilePath)
    {
        Texture2D Tex2D;
        byte[] FileData;

        if (File.Exists(FilePath))
        {
            FileData = File.ReadAllBytes(FilePath);
            Tex2D = new Texture2D(2, 2);
            if (Tex2D.LoadImage(FileData))
                return Tex2D;
        }
        return null;
    }
}