﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.IO;
using UnityEngine.UI;


public class InputManager : MonoBehaviour {
    private static InputManager instance;

    public static InputManager Instance
    {
        get
        {
            if (instance == null)
            {
                instance = FindObjectOfType(typeof(InputManager))
                    as InputManager;
            }

            return instance;
        }
    }

    private bool IsButtonDownPrev { get; set; }
    private bool IsButtonDown
    {
        get { return Input.GetKey(KeyCode.Space) || Input.GetKey(KeyCode.Joystick1Button0); }
    }
    
    public MotionState CurrentMotionState { get; set; }

    public bool IsButtonPressed
    {
        get
        {
            return !IsButtonDownPrev && IsButtonDown;
        }
    }

    public bool IsButtonReleased
    {
        get
        {
            return IsButtonDownPrev && !IsButtonDown;
        }
    }

    public bool IsButtonHolding
    {
        get
        {
            return IsButtonDownPrev && IsButtonDown;
        }
    }

    // Use this for initialization
    void Start()
    {
    }

    // Update is called once per frame
    void Update()
    {
        IsButtonDownPrev = IsButtonDown;
    }
}