﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class GameManager : MonoBehaviour {
    private static GameManager instance;
    public static GameManager Instance
    {
        get
        {
            if (instance == null)
            {
                instance = FindObjectOfType(typeof(GameManager))
                    as GameManager;

                instance.CurrentTrack
                    = new TrackInfo("Assets/Tracks/Test/Test.bpe");
            }

            return instance;
        }
    }
    
    public TrackInfo CurrentTrack { get; set; }

    private int combo = 0;
    public int Combo
    {
        get { return combo; }
        set
        {
            if (value > LongestCombo)
                LongestCombo = value;
            combo = value;
        }
    }
    public int LongestCombo { get; private set; }
    public int Score { get; set; }
    public Dictionary<Judge, int> JudgeCount = new Dictionary<Judge, int>
    {
        { Judge.JudgeList[0], 0 },
        { Judge.JudgeList[1], 0 },
        { Judge.JudgeList[2], 0 },
        { Judge.JudgeList[3], 0 },
    };

    // Use this for initialization
    void Start()
    {
        DontDestroyOnLoad(Instance);
    }
	
    // Update is called once per frame
    void Update()
    {
    }

    public void SceneTransition(string sceneName)
    {
        SceneManager.LoadScene("Scene/" + sceneName);
    }
}
