﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class InputManager : MonoBehaviour {
    private static InputManager instance;
    public static InputManager Instance
    {
        get
        {
            if (instance == null)
            {
                instance = FindObjectOfType(typeof(InputManager))
                    as InputManager;
            }

            return instance;
        }
    }

    private bool IsButtonDown { get; set; }

    public bool IsButtonPressed
    {
        get
        {
            return !IsButtonDown && Input.anyKey;
        }
    }

    public bool IsButtonReleased
    {
        get
        {
            return IsButtonDown && !Input.anyKey;
        }
    }

    public bool IsButtonHolding
    {
        get
        {
            return IsButtonDown && Input.anyKey;
        }
    }

    // Use this for initialization
    void Start()
    {
    }
	
    // Update is called once per frame
    void Update()
    {
        IsButtonDown = Input.anyKey;
    }
}