﻿using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

public class TrackManager : MonoBehaviour {
    [SerializeField]
    GameObject trackList;

    [SerializeField]
    GameObject trackItemPrefab;

    [SerializeField]
    GameObject trackInfo;

    [SerializeField]
    GameObject trackInfoItemPrefab;

    [SerializeField]
    Texture2D[] backgrounds;
    private int currentBackgroundIndex = 0;

    public Text Artist;
    public Text BPM;

    private GameObject selectedTrackItem = null;

    private void TrackBrowse()
    {
        currentBackgroundIndex = (currentBackgroundIndex + 1) % 2;
        trackList.GetComponent<RawImage>().texture = backgrounds[currentBackgroundIndex];

        if (selectedTrackItem != null)
            selectedTrackItem.GetComponentInChildren<Text>().color = Color.white;
        selectedTrackItem = trackList.transform.GetChild(2).gameObject;
        selectedTrackItem.GetComponentInChildren<Text>().color = Color.black;

        if (selectedTrackItem == null)
            return;
        Artist.text = "Artist  :" + selectedTrackItem.gameObject.GetComponent<TrackInfoHolder>().trackInfo.Artist.ToString();
        BPM.text = "BPM    :" + selectedTrackItem.gameObject.GetComponent<TrackInfoHolder>().trackInfo.BPM.ToString();

        for (int i = 0; i < trackInfo.transform.childCount; i++)
            Destroy(trackInfo.transform.GetChild(i).gameObject);

        foreach (string trackItem in selectedTrackItem.gameObject.GetComponent<TrackInfoHolder>().trackInfo.TrackList)
        {
            Instantiate(trackInfoItemPrefab, trackInfo.transform).GetComponent<Text>().text = trackItem;
        }
    }

    // Use this for initialization
    void Start()
    {
        LoadTracks();
        TrackBrowse();
    }
	
    // Update is called once per frame
    void Update()
    {
        if (trackList.transform.childCount < 0)
            return;

        if (Input.GetKeyDown(KeyCode.DownArrow))
        {
            trackList.transform.GetChild(0).SetAsLastSibling();
            TrackBrowse();
        }
        if (Input.GetKeyDown(KeyCode.UpArrow))
        {
            trackList.transform.GetChild(trackList.transform.childCount - 1).SetAsFirstSibling();
            TrackBrowse();
        }
        if (InputManager.Instance.IsButtonPressed)
            StartTrack();
    }
    
    void LoadTracks()
    {
        var files = new DirectoryInfo("Assets/Tracks").GetFiles("*.bpe", SearchOption.AllDirectories);

        List<TrackInfo> tracks = files.Select(s => new TrackInfo(s)).ToList();
        while (tracks.Count() < 5)
            tracks.AddRange(tracks);

        foreach (TrackInfo track in tracks)
        {
            var trackItem = Instantiate(trackItemPrefab, trackList.transform);

            trackItem.AddComponent<TrackInfoHolder>().trackInfo = track;
        }
    }

    public void StartTrack()
    {
        // TODO: disable start button if nothing selected

        var holder = selectedTrackItem.GetComponent<TrackInfoHolder>();

        GameManager.Instance.CurrentTrack = holder.trackInfo;

        Destroy(GetComponent<InputManager>());
        Destroy(this);

        GameManager.Instance.SceneTransition("InGame");
    }
}