using System;
using System.Collections;
using UnityEngine;

public class Guard : MotionNote
{
    enum Hand { Both, Left, Right }
    Hand hand;

    private static Sprite imageB = LoadNewSprite("");
    private static Sprite imageL = LoadNewSprite("");
    private static Sprite imageR = LoadNewSprite("");

    public override Sprite Image
    {
        get
        {
            switch (hand)
            {
                default:
                case Hand.Both:
                    return imageB;
                case Hand.Left:
                    return imageL;
                case Hand.Right:
                    return imageR;
            }
        }
    }

    private bool isChecked = false;
    public override bool IsChecked
    {
        get
        {
            return isChecked;
        }
    }

    public Guard(string key, float timing) : this(key, timing, 0f)
    {
    }

    public Guard(string key, float timing, float end = 0f) : this(timing, end)
    {
        switch (key)
        {
            case "BG":
                hand = Hand.Both;
                break;
            case "LG":
                hand = Hand.Left;
                break;
            case "RG":
                hand = Hand.Right;
                break;
        }
    }
    public Guard(float timing, float end = 0f) : base(timing, end)
    {
    }

    public override IEnumerator Checkpoint(MotionNote obj)
    {
        var motionState = InputManager.Instance.CurrentMotionState;
        var motion = motionState;

        while (motion != MotionState.CLAP_PREPARE)
            yield return false;

        Activated = true;

        yield break;
    }

    public override bool FinalJudgeAction()
    {
        return false;
    }
}
