using System;
using System.Collections;
using UnityEngine;

public class PushUp : MotionNote
{
    enum Hand { Both, Left, Right }
    Hand hand;

    private static Sprite image = LoadNewSprite("");
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public PushUp(string key, float timing) : this(timing)
    {
        switch (key)
        {
            case "BP":
                hand = Hand.Both;
                break;
            case "LP":
                hand = Hand.Left;
                break;
            case "RP":
                hand = Hand.Right;
                break;
        }
    }
    public PushUp(float timing) : base(timing)
    {
    }

    private bool isChecked = false;
    public override bool IsChecked
    {
        get
        {
            return isChecked;
        }
    }

    public override IEnumerator Checkpoint(MotionNote obj)
    {
        var motionState = InputManager.Instance.CurrentMotionState;
        var motion = motionState;

        while (motion != MotionState.CLAP_PREPARE)
            yield return false;

        Activated = true;

        yield break;
    }

    public override bool FinalJudgeAction()
    {
        throw new NotImplementedException();
    }
}
