using System;
using System.Collections;
using UnityEngine;

public class Clap : MotionNote
{
    private static Sprite image = LoadNewSprite("Assets/MotionNotes/CP.png");
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public Clap(string key, float timing) : base(timing)
    {
    }
    public Clap(float timing) : base(timing)
    {
    }

    public override void Checkpoint()
    {
        var motion = InputManager.Instance.CurrentMotionState;

        if ((motion & MotionState.CLAP_PREPARE) == 0)
            return;

        IsChecked = true;
    }

    public override bool FinalJudgeAction()
    {
        var motion = InputManager.Instance.CurrentMotionState;

        if (IsChecked && (motion & MotionState.CLAP_DONE) != 0)
        {
            return true;
        }

        return false;
    }
}
