﻿using System.Collections;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

public class TrackManager : MonoBehaviour {
    [SerializeField]
    GameObject trackList;

    [SerializeField]
    GameObject trackItemPrefab;

    private GameObject selectedTrackItem = null;

	// Use this for initialization
	void Start () {
        LoadTracks();
	}
	
	// Update is called once per frame
	void Update () {
		
	}
    
    void LoadTracks()
    {
        string[] testTracks = { "Track1", "Track2", "Some Other Track", "Foo", "Bar" };
        TrackInfo[] tracks = testTracks.Select(s => new TrackInfo(s)).ToArray();

        foreach (TrackInfo track in tracks)
        {
            var trackItem = Instantiate(trackItemPrefab, trackList.transform);

            trackItem.AddComponent<TrackInfoHolder>().trackInfo = track;

            trackItem.GetComponent<Button>().onClick
                .AddListener(SelectTrackItem);
        }
    }
    
    void SelectTrackItem()
    {
        var caller = EventSystem.current.currentSelectedGameObject;

        // TODO: deactivate selected button

        selectedTrackItem = caller;
    }

    public void StartTrack()
    {
        // TODO: disable start button if nothing selected

        var holder = selectedTrackItem.GetComponent<TrackInfoHolder>();

        GameManager.Instance.CurrentTrack = holder.trackInfo;

        GameManager.Instance.SceneTransition("InGame");
    }
}