﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class JudgeManager : MonoBehaviour {
    [SerializeField]
    float latency = 225f;

    private float elapsedTime = 0;

    private float MsPerBeat
    {
        get { return 60 * 1000f / GameManager.Instance.CurrentTrack.BPM; }
    }

    // Use this for initialization
    void Start()
    {
    }

    // Update is called once per frame
    void Update()
    {
        elapsedTime += Time.deltaTime * 1000;

        Judge judge = Judge.TestJudge(elapsedTime);

        if (judge.IsNonEmptyMiss(elapsedTime))
        {
            elapsedTime -= 2 * MsPerBeat;
        }

        bool isJumpButtonPressed = true;

        if (isJumpButtonPressed)
        {
            if (judge != Judge.MISS)
            {
                elapsedTime -= 2 * MsPerBeat;
            }

            if (!judge.IsBreak)
            {
            }
            else
            {
            }
        }
    }
}
