﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;

public class Judge
{
    public static readonly List<Judge> JudgeList = new List<Judge>
    {
        new Judge("PERFECT") { ButtonTimingRange = 80f, Score = 10, Color = Color.cyan },
        new Judge("GOOD")    { ButtonTimingRange = 100f, Score = 7, Color = Color.yellow },
        new Judge("BAD")     { ButtonTimingRange = 120f, Score = 3, Color = Color.blue, IsBreak = true },
        new Judge("MISS")    { Score = 0, Color = Color.red, IsBreak = true }
    };

    private Judge()
    {
        ButtonTimingRange = 0f;
        MotionTimingRange = 0f;
        Score = 0;
        IsBreak = false;
        Color = Color.black;
    }

    private Judge(string name) : this() { Name = name; }

    public string Name { get; private set; }

    public float ButtonTimingRange { get; private set; }
    public float MotionTimingRange { get; private set; }
    public float Score { get; private set; }
    public bool  IsBreak { get; private set; }
    public Color Color { get; private set; }

    public static readonly Judge MISS = JudgeList.Last();
    private static readonly float MaxButtonTimingRange = JudgeList[2].ButtonTimingRange;

    public static Judge TestJudge(float elapsedTime)
    {
        foreach (Judge testingJudge in JudgeList)
        {
            if (Mathf.Abs(elapsedTime) < testingJudge.ButtonTimingRange)
            {
                return testingJudge;
            }
        }

        return JudgeList.Last();
    }

    public bool IsNonEmptyMiss(float elapsedTime)
    {
        return this == MISS && elapsedTime > MaxButtonTimingRange;
    }
}