﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class GameManager : MonoBehaviour {
    private static GameManager instance;
    public static GameManager Instance
    {
        get
        {
            if (instance == null)
            {
                instance = FindObjectOfType(typeof(GameManager)) as GameManager;
            }

            return instance;
        }
    }
    
    public TrackInfo CurrentTrack { get; set; }

    // Use this for initialization
    void Start () {
        DontDestroyOnLoad(Instance);
	}
	
	// Update is called once per frame
	void Update () {
		
	}

    public void SceneTransition(string sceneName)
    {
        SceneManager.LoadScene("Scene/" + sceneName);
    }
}
