﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;

public class Judge
{
    public static readonly List<Judge> JudgeList = new List<Judge>
    {
        new Judge("PERFECT") { ButtonTimingRange = 80f,  Score = 2, Color = Color.cyan },
        new Judge("GOOD")    { ButtonTimingRange = 100f, Score = 1, Color = Color.yellow },
        new Judge("BAD")     { ButtonTimingRange = 120f, Color = Color.blue, IsBreak = true },
        new Judge("MISS")    { Color = Color.red, IsBreak = true }
    };

    private Judge()
    {
        ButtonTimingRange = 0f;
        MotionTimingRange = ButtonTimingRange;
        Score = 0;
        IsBreak = false;
        Color = Color.black;
    }

    private Judge(string name) : this() { Name = name; }

    public string Name { get; private set; }

    public float ButtonTimingRange { get; private set; }
    public float MotionTimingRange { get; private set; }
    public int   Score { get; private set; }
    public bool  IsBreak { get; private set; }
    public Color Color { get; private set; }

    public static readonly Judge MISS = JudgeList.Last();
    private static readonly
        float MaxButtonTimingRange = JudgeList[2].ButtonTimingRange;

    public static Judge TestJudge(Note note, float elapsedTime, bool end = false)
    {
        float timing = end ? note.EndTiming : note.StartTiming;
        float difference = Mathf.Abs(elapsedTime - timing);

        foreach (Judge judge in JudgeList)
        {
            if (difference < judge.ButtonTimingRange)
            {
                return judge;
            }
        }

        return JudgeList.Last();
    }

    public static bool IsNonEmptyMiss(Note note, float elapsedTime, bool end = false)
    {
        float timing = end ? note.EndTiming : note.StartTiming;
        return elapsedTime - timing > MaxButtonTimingRange;
    }
}