﻿namespace KinectModule
{
    public class SourceBuffer
    {
        public byte[]   ColorBuffer
        { get; private set; }
        public byte[]   BodyIndexBuffer
        { get; private set; }
        public ushort[] DepthBuffer
        { get; private set; }
        public IBody[]  BodyBuffer
        { get; private set; }

        public SourceBuffer()
        {
            ColorBuffer     = new byte  [KinectConstants.ColorWidth *
                                         KinectConstants.ColorHeight *
                                         KinectConstants.ColorCount];
            BodyIndexBuffer = new byte  [KinectConstants.DepthWidth *
                                         KinectConstants.DepthHeight];
            DepthBuffer     = new ushort[KinectConstants.DepthWidth *
                                         KinectConstants.DepthHeight];
            BodyBuffer      = new IBody [KinectConstants.BodyCount];
        }

        public void UpdateBuffers(IMultiSourceFrame sourceFrame)
        {
            ColorBuffer     = sourceFrame.LastColorFrame    .GetData();
            BodyIndexBuffer = sourceFrame.LastBodyIndexFrame.GetData();
            DepthBuffer     = sourceFrame.LastDepthFrame    .GetData();
            BodyBuffer      = sourceFrame.LastBodyFrame     .GetData();
        }
    }
}