﻿using System.Runtime.InteropServices;
using Windows.Kinect;

namespace KinectModule
{
    public class RealColorFrame : IColorFrame
    {
        private static byte[] _Buffer = new byte[KinectConstants.ColorWidth *
                                                 KinectConstants.ColorHeight *
                                                 KinectConstants.ColorCount];

        public RealColorFrame(ColorFrame frame)
        {
            if (frame != null)
            {
                var ColorData = GCHandle.Alloc(_Buffer, GCHandleType.Pinned);
                frame.CopyConvertedFrameDataToIntPtr(ColorData.AddrOfPinnedObject(), (uint)_Buffer.Length, ColorImageFormat.Rgba);
                ColorData.Free();
            }
        }

        public byte[] GetData()
        {
            return _Buffer;
        }
    }
}