using System;
using System.Collections;
using UnityEngine;

public class PushUp : MotionNote
{
    enum Hand { Both, Left, Right }
    Hand hand;

    private static Sprite image = LoadNewSprite("");
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public PushUp(string key, float timing) : this(timing)
    {
        switch (key)
        {
            case "BP":
                hand = Hand.Both;
                break;
            case "LP":
                hand = Hand.Left;
                break;
            case "RP":
                hand = Hand.Right;
                break;
        }
    }
    public PushUp(float timing) : base(timing)
    {
    }

    public override IEnumerator Checkpoint()
    {
        var motionState = InputManager.Instance.CurrentMotionState;
        var motion = motionState;

        while (motion != MotionState.CLAP_PREPARE)
            yield return false;

        Activated = true;

        yield break;
    }

    public override bool FinalJudgeAction()
    {
        throw new NotImplementedException();
    }
}
