using System;
using System.Collections;
using UnityEngine;

public class Piano : MotionNote
{
    enum Hand { Both, Left, Right }
    Hand hand;

    private static Sprite image = LoadNewSprite("");
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public Piano(string key, float timing) : this(timing)
    {
        switch (key)
        {
            case "BI":
                hand = Hand.Both;
                break;
            case "LI":
                hand = Hand.Left;
                break;
            case "RI":
                hand = Hand.Right;
                break;
        }
    }
    public Piano(float timing) : base(timing)
    {
    }

    public override IEnumerator Checkpoint()
    {
        var motionState = InputManager.Instance.CurrentMotionState;
        var motion = motionState;

        while (motion != MotionState.CLAP_PREPARE)
            yield return false;

        Activated = true;

        yield break;
    }

    public override bool FinalJudgeAction()
    {
        throw new NotImplementedException();
    }
}
