using System;
using System.Collections;
using UnityEngine;

public class Jump : MotionNote
{
    private static Sprite image = new Sprite();
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public Jump(string key, float timing) : this(timing)
    {
    }
    public Jump(float timing) : base(timing)
    {
        downCount = 0;
    }

    private float spineHeight;
    private int downCount;

    public override IEnumerator Checkpoint()
    {
        float currentSpineHeight
            = InputManager.Instance
            .Joints[Windows.Kinect.JointType.SpineBase].Position.Y;

        while (downCount < 10 && currentSpineHeight <= spineHeight - 0.1f)
        {
            spineHeight = currentSpineHeight;
            currentSpineHeight
               = InputManager.Instance
               .Joints[Windows.Kinect.JointType.SpineBase].Position.Y;

            downCount++;
            yield return false;
        }

        if (downCount >= 10)
            Activated = true;

        yield break;
    }

    public override bool FinalJudgeAction()
    {
        float currentSpineHeight
            = InputManager.Instance
            .Joints[Windows.Kinect.JointType.SpineBase].Position.Y;

        return currentSpineHeight >= spineHeight;
    }
}
