using System;
using System.Collections;
using UnityEngine;

public class Guard : MotionNote
{
    enum Hand { Both, Left, Right }
    Hand hand;

    private static Sprite image = LoadNewSprite("");
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public Guard(string key, float timing, float end = 0f) : this(timing, end)
    {
        switch (key)
        {
            case "BG":
                hand = Hand.Both;
                break;
            case "LG":
                hand = Hand.Left;
                break;
            case "RG":
                hand = Hand.Right;
                break;
        }
    }
    public Guard(float timing, float end = 0f) : base(timing, end)
    {
    }

    public override IEnumerator Checkpoint()
    {
        var motionState = InputManager.Instance.CurrentMotionState;
        var motion = motionState;

        while (motion != MotionState.CLAP_PREPARE)
            yield return false;

        Activated = true;

        yield break;
    }

    public override bool FinalJudgeAction()
    {
        throw new NotImplementedException();
    }
}
