﻿using TrackAnalysis;
using NUnit.Framework;

class NoteMakerTests
{
    [Test]
    public void Made_Note_Should_Null_When_Note_Type_SBT_Code_CP()
    {
        var obj = new NoteMaker();
        var note = obj.Make("CP", "SBT", 0);

        var expected = true;
        var actual = (note == null);

        Assert.AreEqual(expected, actual, "Made note should be null value when note type is SBT and code is CP");
    }

    [Test]
    public void Made_Note_Should_Null_When_Note_Type_SMO_Code_AA()
    {
        var obj = new NoteMaker();
        var note = obj.Make("AA", "SMO", 0);

        var expected = true;
        var actual = (note == null);

        Assert.AreEqual(expected, actual, "Made note should be null value when note type is SMO and code is AA");
    }

    [Test]
    public void Made_Note_Should_Short_When_Note_Type_SBT()
    {
        var obj = new NoteMaker();
        var note = obj.Make("AA", "SBT", 0);

        var expected = true;
        var actual = (note.Type == NoteType.SBT);

        Assert.AreEqual(expected, actual, "Made note should be short when note type is SBT");
    }

    [Test]
    public void Made_Note_Should_Long_When_Note_Type_LBT()
    {
        var obj = new NoteMaker();
        var tmp  = obj.Make("AA", "LBT", 0);
        var note = obj.Make("AA", "LBT", 1);

        var expected = true;
        var actual = (tmp == null &&
                      note.Type == NoteType.LBT);

        Assert.AreEqual(expected, actual, "Made note should be long when note type is LBT");
    }

    [Test]
    public void Made_Note_Should_Short_When_Note_Type_SMO_Code_CP()
    {
        var obj = new NoteMaker();
        var note = obj.Make("CP", "SMO", 0);

        var expected = true;
        var actual = (note.Type == NoteType.SMO);

        Assert.AreEqual(expected, actual, "Made note should be short when note type is SMO and code is CP");
    }

    [Test]
    public void Made_Note_Should_Long_When_Note_Type_LMO_Code_CP()
    {
        var obj = new NoteMaker();
        var tmp  = obj.Make("CP", "LMO", 0);
        var note = obj.Make("CP", "LMO", 1);

        var expected = true;
        var actual = (tmp == null &&
                      note.Type == NoteType.LMO);

        Assert.AreEqual(expected, actual, "Made note should be long when note type is LMO and code is CP");
    }

    [Test]
    public void Short_Short_Should_Made_Correctly()
    {
        var obj = new NoteMaker();
        var note1 = obj.Make("AA", "SBT", 0);
        var note2 = obj.Make("AA", "SBT", 1);

        var expected = true;
        var actual = (note1.Type == NoteType.SBT &&
                      note2.Type == NoteType.SBT);

        Assert.AreEqual(expected, actual, "2 short notes should be made correctly");
    }

    [Test]
    public void Short_Long_Should_Made_Correctly()
    {
        var obj = new NoteMaker();
        var note1 = obj.Make("AA", "SBT", 0);
        var tmp   = obj.Make("AA", "LBT", 1);
        var note2 = obj.Make("AA", "LBT", 2);

        var expected = true;
        var actual = (tmp        == null         &&
                      note1.Type == NoteType.SBT &&
                      note2.Type == NoteType.LBT);

        Assert.AreEqual(expected, actual, "The short next long note should be made correctly");
    }

    [Test]
    public void Long_Short_Should_Made_Correctly()
    {
        var obj = new NoteMaker();
        var tmp = obj.Make("AA", "LBT", 0);
        var note1 = obj.Make("AA", "LBT", 1);
        var note2 = obj.Make("AA", "SBT", 2);

        var expected = true;
        var actual = (tmp        == null         && 
                      note1.Type == NoteType.LBT &&
                      note2.Type == NoteType.SBT);

        Assert.AreEqual(expected, actual, "The long next short note should be made correctly");
    }

    [Test]
    public void Long_Long_Should_Made_Correctly()
    {
        var obj = new NoteMaker();
        var tmp1  = obj.Make("AA", "LBT", 0);
        var note1 = obj.Make("AA", "LBT", 1);
        var tmp2  = obj.Make("AA", "LBT", 2);
        var note2 = obj.Make("AA", "LBT", 3);

        var expected = true;
        var actual = (tmp1       == null         &&
                      tmp2       == null         &&
                      note1.Type == NoteType.LBT &&
                      note2.Type == NoteType.LBT);

        Assert.AreEqual(expected, actual, "2 long notes should be made correctly");
    }

    [Test]
    public void Short_Short_Should_Made_Correctly_When_Code_CP()
    {
        var obj = new NoteMaker();
        var note1 = obj.Make("CP", "SMO", 0);
        var note2 = obj.Make("CP", "SMO", 1);

        var expected = true;
        var actual = (note1.Type == NoteType.SMO &&
                      note2.Type == NoteType.SMO);

        Assert.AreEqual(expected, actual, "2 short notes should be made correctly when code is cp");
    }

    [Test]
    public void Short_Long_Should_Made_Correctly_When_Code_CP()
    {
        var obj = new NoteMaker();
        var note1 = obj.Make("CP", "SMO", 0);
        var tmp   = obj.Make("CP", "LMO", 1);
        var note2 = obj.Make("CP", "LMO", 2);

        var expected = true;
        var actual = (tmp        == null         &&
                      note1.Type == NoteType.SMO &&
                      note2.Type == NoteType.LMO);

        Assert.AreEqual(expected, actual, "The short next long note should be made correctly when code is cp");
    }

    [Test]
    public void Long_Short_Should_Made_Correctly_When_Code_CP()
    {
        var obj = new NoteMaker();
        var tmp   = obj.Make("CP", "LMO", 0);
        var note1 = obj.Make("CP", "LMO", 1);
        var note2 = obj.Make("CP", "SMO", 2);

        var expected = true;
        var actual = (tmp        == null         &&
                      note1.Type == NoteType.LMO &&
                      note2.Type == NoteType.SMO);

        Assert.AreEqual(expected, actual, "The long next short note should be made correctly when code is cp");
    }

    [Test]
    public void Long_Long_Should_Made_Correctly_When_Code_CP()
    {
        var obj = new NoteMaker();
        var tmp1  = obj.Make("CP", "LMO", 0);
        var note1 = obj.Make("CP", "LMO", 1);
        var tmp2  = obj.Make("CP", "LMO", 2);
        var note2 = obj.Make("CP", "LMO", 3);

        var expected = true;
        var actual = (tmp1 == null &&
                      tmp2 == null &&
                      note1.Type == NoteType.LMO &&
                      note2.Type == NoteType.LMO);

        Assert.AreEqual(expected, actual, "2 long notes should be made correctly when code is cp");
    }
}