﻿using NUnit.Framework;
using Windows.Kinect;
using KinectModule;

public class KinectAccessManagerTests
{
    [Test]
    public void CoordinateMapper_NotEqual_Null()
    {
        // Use the Assert class to test conditions.

        using (var obj = new KinectAccessManager())
        {
            obj.Access();

            var expected = null as CoordinateMapper;
            var actual = obj.CoordinateMapper;

            Assert.AreNotEqual(expected, actual, "CoordinateMapper should not be null value.");
        }
    }

    [Test]
    public void SourceFrame_NullFrame_Synchronized_When_SourceFrame()
    {
        using (var obj = new KinectAccessManager())
        {
            obj.Access();

            var expected = true;
            var actual = ((obj.SourceFrame == null) == obj.NullFrame);

            Assert.AreEqual(expected, actual, "SourceFrame and NullFrame should be synchronized when source frame.");
        }
    }

    [Test]
    public void SourceFrame_NullFrame_Synchronized_When_NullFrame()
    {
        using (var obj = new KinectAccessManager())
        {
            var expected = true;
            var actual = ((obj.SourceFrame == null) == obj.NullFrame);

            Assert.AreEqual(expected, actual, "SourceFrame and NullFrame should be synchronized when source frame.");
        }
    }

    [Test]
    public void SourceFrame_Equal_Null_When_Dispose()
    {
        using (var obj = new KinectAccessManager())
        {
            var expected = null as MultiSourceFrame;
            var actual = obj.SourceFrame;

            Assert.AreEqual(expected, actual, "SourceFrame should be null value.");
        }
    }

    [Test]
    public void NullFrame_Equal_True_When_Dispose()
    {
        using (var obj = new KinectAccessManager())
        {
            var tmp = obj.SourceFrame;

            var expected = true;
            var actual = obj.NullFrame;

            Assert.AreEqual(expected, actual, "NullFrame should be true.");
        }
    }

    [Test]
    public void IsAccess_Equal_True_When_Access()
    {
        using (var obj = new KinectAccessManager())
        {
            obj.Access();

            var expected = true;
            var actual = obj.IsAccess;

            Assert.AreEqual(expected, actual, "IsAccess should be true.");
        }
    }

    [Test]
    public void IsAccess_Equal_False_When_Dispose()
    {
        using (var obj = new KinectAccessManager())
        {
            var expected = false;
            var actual = obj.IsAccess;

            Assert.AreEqual(expected, actual, "IsAccess should be false.");
        }
    }
}
