﻿using TrackAnalysis;
using NUnit.Framework;

class ButtonNoteMakerTests
{
    [Test]
    public void Made_Note_Should_Null_When_Invalid_Note_Type()
    {
        var obj = new ButtonNoteMaker();
        var note = obj.Make("AA", "SMO", 0);

        var expected = true;
        var actual = (note == null);

        Assert.AreEqual(expected, actual, "Made note should be null value when invalid note type");
    }

    [Test]
    public void Made_Note_Should_Short_When_Note_Type_SBT()
    {
        var obj = new ButtonNoteMaker();
        var note = obj.Make("AA", "SBT", 0);

        var expected = true;
        var actual = (note.Type == NoteType.SBT);

        Assert.AreEqual(expected, actual, "Made note should be short when note type is SBT");
    }

    [Test]
    public void Made_Note_Should_Long_When_Note_Type_LBT()
    {
        var obj = new ButtonNoteMaker();
        var tmp  = obj.Make("AA", "LBT", 0);
        var note = obj.Make("AA", "LBT", 1);

        var expected = true;
        var actual = (tmp       == null &&
                      note.Type == NoteType.LBT);

        Assert.AreEqual(expected, actual, "Made note should be long when note type is LBT");
    }

    [Test]
    public void Short_Short_Should_Made_Correctly()
    {
        var obj = new ButtonNoteMaker();
        var note1 = obj.Make("AA", "SBT", 0);
        var note2 = obj.Make("AA", "SBT", 1);

        var expected = true;
        var actual = (note1.Type == NoteType.SBT &&
                      note2.Type == NoteType.SBT);

        Assert.AreEqual(expected, actual, "2 short notes should be made correctly");
    }

    [Test]
    public void Short_Long_Should_Made_Correctly()
    {
        var obj = new ButtonNoteMaker();
        var note1 = obj.Make("AA", "SBT", 0);
        var tmp   = obj.Make("AA", "LBT", 1);
        var note2 = obj.Make("AA", "LBT", 2);

        var expected = true;
        var actual = (tmp        == null         &&
                      note1.Type == NoteType.SBT &&
                      note2.Type == NoteType.LBT);

        Assert.AreEqual(expected, actual, "The short next long note should be made correctly");
    }

    [Test]
    public void Long_Short_Should_Made_Correctly()
    {
        var obj = new ButtonNoteMaker();
        var tmp = obj.Make("AA", "LBT", 0);
        var note1 = obj.Make("AA", "LBT", 1);
        var note2 = obj.Make("AA", "SBT", 2);

        var expected = true;
        var actual = (tmp        == null         && 
                      note1.Type == NoteType.LBT &&
                      note2.Type == NoteType.SBT);

        Assert.AreEqual(expected, actual, "The long next short note should be made correctly");
    }

    [Test]
    public void Long_Long_Should_Made_Correctly()
    {
        var obj = new ButtonNoteMaker();
        var tmp1  = obj.Make("AA", "LBT", 0);
        var note1 = obj.Make("AA", "LBT", 1);
        var tmp2  = obj.Make("AA", "LBT", 2);
        var note2 = obj.Make("AA", "LBT", 3);

        var expected = true;
        var actual = (tmp1       == null         &&
                      tmp2       == null         &&
                      note1.Type == NoteType.LBT &&
                      note2.Type == NoteType.LBT);

        Assert.AreEqual(expected, actual, "2 long notes should be made correctly");
    }
}