﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class GameManager : MonoBehaviour {
    private static GameManager instance;
    public static GameManager Instance
    {
        get
        {
            if (instance == null)
            {
                instance = FindObjectOfType(typeof(GameManager))
                    as GameManager;

                instance.CurrentTrack
                    = new TrackInfo("Assets/Tracks/Tutorial/tutorial1.bpe");
            }

            return instance;
        }
    }
    
    public TrackInfo CurrentTrack { get; set; }

    public int Combo { get; set; }
    public int Score { get; set; }

    // Use this for initialization
    void Start()
    {
        DontDestroyOnLoad(Instance);
    }
	
    // Update is called once per frame
    void Update()
    {
    }

    public void SceneTransition(string sceneName)
    {
        SceneManager.LoadScene("Scene/" + sceneName);
    }
}
