﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class JudgeManager : MonoBehaviour
{
    private static JudgeManager instance;
    public static JudgeManager Instance
    {
        get
        {
            if (instance == null)
            {
                instance = FindObjectOfType(typeof(JudgeManager)) as JudgeManager;
            }

            return instance;
        }
    }

    [SerializeField]
    float latency = 225f;
    [SerializeField]
    GameObject offset;

    private float elapsedTime = 0;

    private float MsPerBeat
    {
        get
        {
            return 60 * 1000f / GameManager.Instance.CurrentTrack.BPM;
        }
    }

    // Use this for initialization
    void Start()
    {
    }

    // Update is called once per frame
    void Update()
    {
        elapsedTime += Time.deltaTime * 1000;
        offset.transform.Translate(-Time.deltaTime * MsPerBeat, 0, 0);

        if (InputManager.Instance.IsButtonDown)
        {
            Judge judge = Judge.TestJudge(elapsedTime + latency);

            if (!judge.IsBreak)
            {
            }
            else
            {
            }
        }
    }
}
