﻿using System;
using System.Collections.Generic;
using UnityEngine;

namespace JudgeModule
{
    public class JudgeManager
    {
        private NoteCondition       condition;
        private List<Note>          notes;
        private NoteJudger          judger;

        private float               interval;
        private GameObject          sample,
                                    appear;

        public JudgeManager(InputManager input,
                            Action endgame,
                            Dictionary<string, GameObject> objects,
                            float bpm)
        {
            condition = new NoteCondition(input);
            judger = new NoteJudger(objects, endgame);
            interval = 60 * 1000f / bpm;

            appear    = objects["appear"];
            sample    = objects["sample"];
            sample.SetActive(false);
        }

        public void JudgeNote(Note note, float timing)
        {
            if (Judge.IsPastNote(note, timing) ||
                note.Component.transform.position.x > appear.transform.position.x)
                return;

            /*if (condition.IsWrongInput(note))
            {
                judger.WrongNoteProc(note);
                return;
            }*/

            if (Judge.IsNoteStart(note, timing))
                PlaySampleMotion(note as MotionNote, timing);

            if (note.IsLong)
                JudgeLongNote(note, timing);
            else
                JudgeShortNote(note, timing);
        }

        void JudgeShortNote(Note note, float timing)
        {
            if (condition.IsShortNoteEntered(note))
                judger.EnteredNoteProc(note, timing);
        }

        void JudgeLongNote(Note note, float timing)
        {
            if (condition.IsLongNoteStartCorrectly(note))
                judger.EnteredNoteProc(note, timing);
            else if (condition.IsLongNoteFinishCorrectly(note, timing))
                judger.CorrectlyStoppedNoteProc(note, timing);
            else if (condition.IsLongNoteFinishIncorrectly(note, timing))
                judger.IncorrectlyStoppedNoteProc(note);
            else if (condition.IsLongNoteHoldCorrectly(note))
                judger.ContinuingNoteProc(note, timing, interval);
        }

        void PlaySampleMotion(MotionNote note, float timing)
        {
            if (!note.SamplePlayed &&
                Mathf.Abs(note.StartTiming - timing - interval) < 20f)
            {
                note.SamplePlayed = true;

                var obj = UnityEngine.Object.Instantiate(sample);

                var sampleDisplay = obj.GetComponent<MotionSampleDisplay>();
                obj.SetActive(false);
                sampleDisplay.sprite = note.Image;
                sampleDisplay.timeout = interval;
                obj.SetActive(true);
            }
        }
    }
}
