﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CloudBehaviour : MonoBehaviour
{
    private ParticleSystem cloud;

    private void Start()
    {
        cloud = GetComponent<ParticleSystem>();
        GameManager.inst.OnMaxHeightChanged += SetHeight;
    }

    private void SetHeight(float height)
    {
        ParticleSystem.ColorOverLifetimeModule module  = cloud.colorOverLifetime;
        module.color = new Color(1, 1, 1, height / 500);
        transform.position = new Vector3(transform.position.x, height - 100, transform.position.z);
    }
}