﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

using DitzelGames.FastIK;

public class PlayerIK : MonoBehaviour
{
    // Start is called before the first frame update

    public GameObject gunTarget;
    public Transform cam;
    public GameObject shoulder;
    public GameObject poleTarget;
    public GameObject lookTarget;


    void Start()
    {
    }

    // Update is called once per frame
    void Update()
    {
        float x = transform.InverseTransformPoint(shoulder.transform.position).x;
        float z = transform.InverseTransformPoint(shoulder.transform.position).z;
        gunTarget.transform.position = transform.TransformPoint(new Vector3(x*2+0.3f, 0.6f, -0.2f)) + cam.forward*0.5f;
        poleTarget.transform.position = transform.TransformPoint(new Vector3(1.0f, 0.3f, -0.1f + z));
        lookTarget.transform.position = transform.position + cam.forward * 100f;

    }

    void OnDrawGizmos()
    {
#if UNITY_EDITOR
        var current = this.transform;
        Gizmos.DrawWireSphere(gunTarget.transform.position, 0.1f);
        Gizmos.DrawWireSphere(poleTarget.transform.position, 0.1f);
#endif

    }

}