﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class RoundRobin : MonoBehaviour
{
    public AudioClip[] clips;
    public float volume = 1.0f;
    public int polyphony = 2;

    List<AudioSource> sources = new List<AudioSource>();
    int currentSource = 0;

    // Start is called before the first frame update
    void Start()
    {
        // Source 생성
        for (int i = 0; i < polyphony; i++)
        {
            var s = gameObject.AddComponent<AudioSource>();
            sources.Add(s);
            s.volume = volume;
        }
    }

    // Update is called once per frame
    void Update()
    {
        
    }

    public void Play()
    {
        AudioSource source = sources[currentSource];
        source.Stop();
        source.clip = clips[Random.Range(0, clips.Length)];
        source.Play();
        NextSource();
    }

    public void Stop()
    {
        foreach (AudioSource source in sources)
        {
            source.Stop();
        }
    }

    void NextSource()
    {
        currentSource++;
        if (currentSource >= polyphony)
        {
            currentSource = 0;
        }
    }
}
