﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerFootstep : MonoBehaviour
{
    public RoundRobin sand;
    public RoundRobin rock;

    public GameObject footL;
    public GameObject footR;

    public float detectHeight;
    public float footstepRetriggerInterval = 0.2f;

    bool hitFloorL;
    bool hitFloorR;

    bool canPlay = true;

    public LayerMask groundMask;

    RoundRobin toPlay;

    // Start is called before the first frame update
    void Start()
    {
    }

    void Update()
    {
        float yL = transform.InverseTransformPoint(footL.transform.position).y;
        float yR = transform.InverseTransformPoint(footR.transform.position).y;
        bool newHitFloorL = yL < detectHeight;
        bool newHitFloorR = yR < detectHeight;

        if (newHitFloorL != hitFloorL)
        {
            hitFloorL = newHitFloorL;
            if(hitFloorL)
            {
                PlayFootstep();
            }
        }
        if (newHitFloorR != hitFloorR)
        {
            hitFloorR = newHitFloorR;
            if (hitFloorR)
            {
                PlayFootstep();
            }
        }
    }

    // Update is called once per frame
    void FixedUpdate()
    {
        // Raycast to Determine the type of terrain.
        RaycastHit hit;
        if (Physics.Raycast(transform.position, new Vector3(0, -1, 0), out hit, 10, groundMask))
        {
            if(hit.collider.gameObject.name == "Desert")
            {
                toPlay = sand;
            } else
            {
                toPlay = rock;
            }
        }
    }

    public void PlayFootstep()
    {
        if (canPlay)
        {
            toPlay.Play();
            canPlay = false;
            StartCoroutine(Retrigger());
        }
    }

    IEnumerator Retrigger()
    {
        yield return new WaitForSecondsRealtime(footstepRetriggerInterval);
        canPlay = true;
    }
}
