﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class GameManager : SingletonBehaviour<GameManager>
{
    private float _maxHeight = 0;
    public float MaxHeight {
        get
        {
            return _maxHeight;
        }
        set
        {
            _maxHeight = value;
            OnMaxHeightChanged?.Invoke(value);
        }
    }

    public Action<float> OnMaxHeightChanged;

	public void GameOver()
	{
		Debug.Log("Game Over!");
		IngameUIManager.inst.gameObject.SetActive(false);
		StartCoroutine(GameOverRoutine());
	}

	private IEnumerator GameOverRoutine()
	{
		yield return new WaitForSeconds(5);
		SceneManager.LoadScene("Ingame", LoadSceneMode.Single);
	}

	public void GameClear()
	{
		StartCoroutine(GameClearRoutine());
	}

	private IEnumerator GameClearRoutine()
	{
		yield return new WaitForSeconds(5);
		SceneManager.LoadScene("Main", LoadSceneMode.Single);
	}
}
