﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerMovement : MonoBehaviour
{
    public Transform groundChecker;
    public LayerMask groundMask;
    public Vector3 gravity;
    public float speed;


    private CharacterController controller;
    private Vector3 velocity;
    private Animator animator;

    private float movement = 0.0f;

    private bool isGrounded = true;


    // Start is called before the first frame update
    void Start()
    {
        controller = GetComponent<CharacterController>();
        animator = GetComponentInChildren<Animator>();
    }
#if UNITY_EDITOR
    private void OnDrawGizmos()
    {
        Gizmos.color = Color.red;
        Gizmos.DrawLine(transform.position, Camera.main.transform.forward.normalized * 200);

        if (Physics.OverlapSphere(groundChecker.position, 0.5f, groundMask).Length == 0)
            Gizmos.color = Color.green;
        Gizmos.DrawSphere(groundChecker.position, 0.1f);
    }
#endif
    // Update is called once per frame
    void Update()
    {
        float vertical = Input.GetAxis("Vertical");
        float horizontal = Input.GetAxis("Horizontal");

        

        if (isGrounded)
        {
            if(Physics.OverlapSphere(groundChecker.position, 0.5f, groundMask).Length == 0)
            {
                isGrounded = false;
            }
        }

        if (!isGrounded)
        {
            if (velocity.y < 0 && Physics.OverlapSphere(groundChecker.position, 0.5f, groundMask).Length > 0)
            {
                isGrounded = true;
            }
        }


        if (isGrounded)
        {
            var groundMovement = (transform.forward * vertical
            + transform.right * horizontal) * speed;
            velocity = Vector3.Lerp(velocity, groundMovement, 0.5f);
            velocity.y = 0;
            
            if (Input.GetButtonDown("Jump"))
            {
                velocity.y = 10.0f;
            }
        } else
        {
            velocity += gravity * Time.deltaTime;
        }

        controller.Move(velocity * Time.deltaTime);
        Animate(vertical, horizontal);
    }

    private void Animate(float vertical, float horizontal)
    {
        animator.SetBool("IsGrounded", isGrounded);
        animator.SetFloat("Vertical", vertical, 0.05f, Time.deltaTime);
        animator.SetFloat("Horizontal", horizontal, 0.05f, Time.deltaTime);

        var movementTarget = Mathf.Clamp(Mathf.Abs(vertical) +  Mathf.Abs(horizontal), 0, 1);
        movement = Mathf.Lerp(movement, movementTarget, 0.1f);

        animator.SetFloat("Movement", normalizedClamp(movement, 0.1f, 0.9f));
        animator.SetBool("Connected", false);
    }

    private float normalizedClamp(float t, float a, float b)
    {
        return (Mathf.Clamp(t, a, b) - a) / (b - a);
    }
}

