﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class MapManager : SingletonBehaviour<MapManager>
{
    private float nextMapBlockGenerateDistance;
    private float nextEnemyGenerateDistance;

    [SerializeField]
    private Bounds mapBound;
    private void OnDrawGizmos()
    {
        Gizmos.color = Color.blue;
        Gizmos.DrawWireCube(mapBound.center, mapBound.size);
    }
    private void Start()
    {
        GameManager.inst.OnMaxHeightChanged += OnMaxHeightChanged;
    }
    public void OnMaxHeightChanged(float height)
    {
        mapBound.center = new Vector3(0, height, 0);
        foreach (Transform child in transform)
        {
            if (child.position.y < height - mapBound.extents.y)
            {
                child.gameObject.SetActive(false);
            }
        }
    }
	public bool IsOutOfMapBounds(Vector3 pos)
	{
		return !mapBound.Contains(pos);
	}
}
