﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[RequireComponent(typeof(CharacterController))]
public class PlayerController : MonoBehaviour
{
    public float distance = 10.0f;


    float velocityY = 0.0f;
    const float gravity = 9.8f;

    public HookBehaviour hook;

    private Rigidbody rb;
	private CapsuleCollider col;
	private DistanceJoint3D joint; 
    private bool isWired;


    
	[SerializeField]
	private Transform groundChecker;
	public LayerMask groundMask;
	private bool IsGrounded
	{
		get {
			return Physics.OverlapSphere(groundChecker.position, 0.01f, groundMask).Length > 0;
		}
	}

	public int MaxHealth { get; private set; }
	private int _health;
	public int Health {
		get
		{
			return _health;
		}
		private set
		{
			_health = value;
			IngameUIManager.inst.UpdatePlayerHealthUI(MaxHealth, _health);
		}
	}

	[SerializeField]
	private float outOfMapTimer = 10;

#if UNITY_EDITOR
    private void OnDrawGizmos()
    {
		Gizmos.color = Color.red;
        Gizmos.DrawLine(transform.position, Camera.main.transform.forward.normalized * 200);

		if (!IsGrounded)
			Gizmos.color = Color.green;
		Gizmos.DrawSphere(groundChecker.position, 0.1f);
	}
#endif

    private void Start()
    {
        Cursor.lockState = CursorLockMode.Locked;
        joint = GetComponent<DistanceJoint3D>();
        rb = GetComponent<Rigidbody>();
		col = GetComponent<CapsuleCollider>();

		//col.enabled = !IsGrounded;
		//cc.enabled = IsGrounded;

		MaxHealth = Health = 100;
    }
    private void Update()
    {
        float vertical = Input.GetAxis("Vertical");
        float horizontal = Input.GetAxis("Horizontal");

        if (Input.GetMouseButtonDown(1))
        {
            if (!hook.gameObject.activeSelf)
            {
                FireHook();
            }
            else
                ReturnHook();
        }
		
		if (IsGrounded)
		{
			rb.velocity = (horizontal * transform.right + vertical * transform.forward).normalized * 10.0f;
			if (Input.GetButtonDown("Jump"))
				rb.velocity += new Vector3(0, 5 -rb.velocity.y, 0);
		}
        else
        {
			if (joint.enabled)
				joint.moveDelta = (horizontal * transform.right + vertical * transform.forward).normalized * 30.0f;
			else
				rb.AddForce(horizontal * Camera.main.transform.right + vertical * Camera.main.transform.forward * 10.0f);
        }

		if (MapManager.inst.IsOutOfMapBounds(transform.position))
		{
			outOfMapTimer -= Time.deltaTime;
			if (outOfMapTimer <= 0)
				Health = 0;
		}
		else
			outOfMapTimer = 10;
	}

    private void LateUpdate()
    {
        IngameUIManager.inst.UpdateHeightText(transform.position.y);
        if (GameManager.inst.MaxHeight < transform.position.y)
        {
            IngameUIManager.inst.UpdateMaxHeightText(transform.position.y);
            GameManager.inst.MaxHeight = transform.position.y;
        }
    }

	private void FireHook()
    {
        joint.enabled = false;
        hook.gameObject.SetActive(true);
        hook.transform.position = transform.position;
        hook.EnableHook(Camera.main.transform.forward.normalized * 200);
    }

    public void ReturnHook()
    {
        joint.enabled = false;
        hook.DisableHook();
        isWired = false;
        //rb.useGravity = true;
    }

    public void ActiveWire()
    {
        joint.enabled = true;
        joint.distance = Vector3.Distance(transform.position, hook.transform.position);
        isWired = true;
        //rb.useGravity = false;
    }

	public void GetDamaged(int damage)
	{
		Health = Mathf.Max(0, Health - damage);
		Camera.main.GetComponent<CameraController>().PlayHitEffect();
	}
}