﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class IngameUIManager : SingletonBehaviour<IngameUIManager>
{
	[SerializeField]
	private GameObject targetLockedUIPrefab;
	private List<Image> targetLockedUIs = new List<Image>();

    [SerializeField]
    private Text heightText;
    [SerializeField]
    private Text maxHeightText;

	[SerializeField]
	private GameObject enemyHealthUIPrefab;

	[SerializeField]
	private Slider playerHealthUI;

	[SerializeField]
	private Image weaponUI;

	[SerializeField]
	private Slider skillUI;
	[SerializeField]
	private Text skillCooltimeText;

	[SerializeField]
	private GameObject comboUI;
	[SerializeField]
	private Text comboText;
	[SerializeField]
	private Text damageText;
	private Coroutine disableComboRoutine;

	public void UpdateTargetLockedUIs(Vector3[] pos)
	{
		int tmp, i = 0;

		int count = targetLockedUIs.Count;

		for (int j = 0; j < pos.Length - count; j++)
		{
			targetLockedUIs.Add(Instantiate(targetLockedUIPrefab, transform).GetComponent<Image>());
		}
		//Debug.Log(targetLockedUIs.Count);
		//Debug.Log(pos.Length);
		for (; i < pos.Length; i++)
		{
			Vector2 viewportPoint = Camera.main.WorldToViewportPoint(pos[i]);
			targetLockedUIs[i].rectTransform.anchorMin = viewportPoint;
			targetLockedUIs[i].rectTransform.anchorMax = viewportPoint;
		}
		for (tmp = i; i < targetLockedUIs.Count; i++)
		{
			Destroy(targetLockedUIs[i].gameObject);
		}
		if (tmp < targetLockedUIs.Count)
		{
			targetLockedUIs.RemoveRange(tmp, targetLockedUIs.Count - tmp);
		}
	}

    public void UpdateMaxHeightText(float maxHeight)
    {
        maxHeightText.text = string.Format("{0:F1}", maxHeight) + " M";
    }

    public void UpdateHeightText(float height)
    {
        heightText.text = string.Format("{0:F1}", height) + " M";
    }

	public Slider CreateNewHealthUI()
	{
		Slider ui = Instantiate(enemyHealthUIPrefab, transform).GetComponent<Slider>();
		Destroy(ui.gameObject, 5);
		return ui;
	}

	public void UpdateEnemyHealthUI(Slider ui, int maxHealth, int curHealth)
	{
		if (ui == null)
			Debug.LogError("There's no health ui available");
		ui.value = curHealth / (float)maxHealth;
	}

	public void UpdatePlayerHealthUI(int maxHealth, int curHealth)
	{
		playerHealthUI.value = (float)curHealth / maxHealth;
	}

	public void UpdateWeaponTypeUI(WeaponType type)
	{
		switch (type)
		{
			case WeaponType.GUN:
				weaponUI.color = Color.blue;
				break;
			case WeaponType.KNIFE:
				weaponUI.color = Color.red;
				break;
		}
	}

	public void UpdateSkillUI(float remain, float time)
	{
		skillUI.value = 1 - remain / time;

		if (remain <= 0)
			skillCooltimeText.text = "";
		else
			skillCooltimeText.text = string.Format("{0:F1}", remain);
	}

	public void UpdateComboUI(int damage)
	{
		if (disableComboRoutine != null)
			StopCoroutine(disableComboRoutine);
		comboUI.SetActive(true);
		comboText.text = (int.Parse(comboText.text.Split(' ')[0]) + 1).ToString() + " Combo!";
		damageText.text = (int.Parse(damageText.text) + damage).ToString();
		disableComboRoutine = StartCoroutine(DisableUI(comboUI, 5));
	
	}

	private IEnumerator DisableUI(GameObject ui, float sec)
	{
		yield return new WaitForSeconds(sec);
		ui.SetActive(false);
	}
}
