﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Missile : Enemy
{
	protected override void InitializeStateMachine()
	{
		State idle = new State("idle");

		idle.StateUpdate += delegate
		{
			rb.velocity = (target.transform.position - transform.position).normalized * moveSpeed;
		};

		stateMachine.AddNewState(idle);
		stateMachine.Transtion("idle");
	}

	private void OnTriggerEnter(Collider other)
	{
		if (other.tag.Contains("Enemy"))
			return;
		other.GetComponent<PlayerController>()?.GetDamaged(attackDamage);
		Destroy(gameObject);
	}
}
