﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CameraController : MonoBehaviour
{
    public Transform target;

    public Vector3 offset;

    [SerializeField]
    private float distance = 10.0f;
    private float currentX = 0.0f;
    private float currentY = 0.0f;
    private float sensitivityX = 4.0f;
    private float sensitivityY = 1.0f;

    private Camera cam;

	[SerializeField]
	private LayerMask blockMask;

	[SerializeField]
	private ParticleSystem hitEffect;

    private void Start()
    {
        cam = GetComponent<Camera>();
    }

    private void Update()
    {
		currentX += Input.GetAxis("Mouse X");
		currentY = Mathf.Clamp(currentY - Input.GetAxis("Mouse Y"), -89, 89);

		Quaternion rotation = Quaternion.Euler(currentY, currentX, 0);
		transform.position = target.position + rotation * new Vector3(0, 0, -distance);
		target.rotation = Quaternion.Euler(0, currentX, 0);
		transform.LookAt(target.position + offset);

		/*
		//Vector3 direction = rotation * Vector3.back;
		//Debug.Log(rotation.eulerAngles);
		float dist;
		RaycastHit hit;
		if (Physics.Raycast(target.position + offset, -transform.forward, out hit, distance, blockMask))
			dist = Mathf.Max(1, hit.distance);
		else
			dist = distance;

		transform.position = target.position + -transform.forward * dist;
		target.rotation = Quaternion.Euler(0, currentX, 0);
		transform.LookAt(target.position + offset);
		*/
	}

	public void PlayHitEffect()
	{
		hitEffect.Play();
	}

    private void LateUpdate()
    {

	}
}
