﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class StateMachine
{
	private Dictionary<string, State> states = new Dictionary<string, State>();

	public State curState = null;

	public void AddNewState(State state)
	{
		states.Add(state.name, state);
	}

	public void AddNewStates(State[] states)
	{
		foreach (var state in states)
		{
			this.states.Add(state.name, state);
		}
	}

	public void Transtion(string name)
	{
		curState?.Exit?.Invoke();
		curState = states[name];
		curState.Enter?.Invoke();
	}
}

public class State
{
	public State(string name)
	{
		this.name = name;
	}
	public string name;
	public Action Enter;
	public Action Exit;
	public Action StateUpdate;
}