﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class HookBehaviour : MonoBehaviour
{
    [SerializeField]
    private LineRenderer lr;
    [SerializeField]
    private Transform player;
	[SerializeField]
	private Transform hookOrigin;

    [SerializeField]
    private Rigidbody rb;

    [SerializeField]
    private float maxDistance;
    private float curDistance;

    public AudioSource shootSound;
    public AudioSource hitSound;
    public AudioSource pullSound;

    private void OnDrawGizmos()
	{
		
	}

	private void Awake()
    {
        rb = GetComponent<Rigidbody>();
        gameObject.SetActive(false);
    }

    private void Update()
    {
        lr.SetPosition(0, transform.position);
        lr.SetPosition(1, hookOrigin.position);
    }

    private void FixedUpdate()
    {
        if (curDistance <= maxDistance)
        {
            curDistance += rb.velocity.magnitude * Time.fixedDeltaTime;
            if (curDistance > maxDistance)
                player.GetComponent<PlayerController>().ReturnHook();
        }
    }

    private void OnCollisionEnter(Collision collision)
    {
        rb.velocity = Vector3.zero;
        player.GetComponent<PlayerController>().ActiveWire();
        hitSound.gameObject.transform.position = transform.position;
        hitSound.Play();

        pullSound.Play();
    }

    public void EnableHook(Vector3 velocity)
    {
        lr.enabled = true;
        lr.SetPosition(0, transform.position);
        lr.SetPosition(1, player.position);
        rb.velocity = velocity;
        curDistance = 0;
        shootSound.Play();
    }

    public void DisableHook()
    {
        lr.enabled = false;
        gameObject.SetActive(false);
        pullSound.Stop();
    }
}
