﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[RequireComponent(typeof(LineRenderer))]
public class Sniper : Enemy
{
	private LineRenderer lr;

	protected override void Start()
	{
		lr = GetComponent<LineRenderer>();
		lr.positionCount = 2;
		base.Start();
	}

	protected override void InitializeStateMachine()
	{
		State idle = new State("idle");
		State detected = new State("detected");

		idle.Enter += delegate
		{
			shotTimer = shotTimeInterval;
			lr.enabled = false;
		};

		idle.StateUpdate += delegate
		{
			if (DetectPlayer())
			{
				stateMachine.Transtion("detected");
			}
		};

		detected.Enter += delegate
		{
			lr.enabled = true;
			Debug.Log("Sniper Detect");
		};

		detected.StateUpdate += AttackTarget;
		detected.StateUpdate += delegate
		{
			lr.SetPosition(0, transform.position);
			lr.SetPosition(1, target.transform.position);
			if (!DetectPlayer())
			{
				stateMachine.Transtion("idle");
			}
		};

		State[] states = { idle, detected };
		stateMachine.AddNewStates(states);

		stateMachine.Transtion("idle");
	}
}