﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;

public class HeadShot : Skill
{
    public float damageTimes;
    private Collider2D target;

#if UNITY_EDITOR
    [MenuItem("Skiils/HeadShot")]
    static void CreateAsset()
    {
        HeadShot skill = CreateInstance<HeadShot>();
        AssetDatabase.CreateAsset(skill,"Assets/" + skill.GetType().Name + ".asset");
    }
#endif

    public override void Aiming()
    {
        throw new System.NotImplementedException();
    }

    private IEnumerator AimingRoutine()
    {
        while (true)
        {
            if (Input.GetMouseButtonDown(0))
            {
                Use();
                break;
            }
            Vector3 mouseWorldPosition = Camera.main.ScreenToWorldPoint(Input.mousePosition);
            target = Physics2D.OverlapPoint(mouseWorldPosition, LayerMask.NameToLayer("Enemy"));
            yield return null;
        }
    }

    public override void Use()
    {
        if (!target)
            return;
        target.GetComponent<Enemy>().Health -= Mathf.CeilToInt(weaponBehaviour.weapon.damage * damageTimes);
    }
}
